/*
 * Decompiled with CFR 0.152.
 */
package jp.javable.tool.jglossary.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.TreeSet;
import jp.javable.tool.jglossary.core.GlossaryComparator;
import jp.javable.tool.jglossary.core.Result;
import jp.javable.tool.jglossary.core.ResultManager;
import jp.javable.tool.jglossary.io.AbstractResultWriter;
import jp.javable.tool.jglossary.io.EmptyPrintStream;
import jp.javable.tool.jglossary.io.HtmlResultWriter;
import jp.javable.tool.jglossary.splitrules.SplitRulesManager;
import jp.javable.tool.jglossary.util.ModifierUtils;
import jp.javable.tool.jglossary.util.StringUtils;

public class JGlossary {
    public static final String VERSION = "0.1.0";
    private String[] terms = new String[0];
    private int availableLength = 1;
    private String[] postfix = new String[0];
    private String[] packages = new String[0];
    private ResultManager resultManager = new ResultManager();
    private SplitRulesManager splitRulesManager = new SplitRulesManager();
    private String splitRule = "ignoreNumbers";
    private String fieldCheckLevel = "private";
    private String methodCheckLevel = "public";
    private String classPath;
    private boolean assortmentError = false;
    private PrintStream tempOut = System.out;
    private boolean verbose = false;
    private String tempPackage = "";

    public void initialize() throws IllegalStateException {
        if (this.verbose) {
            this.tempOut.print("\u521d\u671f\u5316\u51e6\u7406\u4e2d.");
        }
        int size = this.packages.length;
        if (this.packages == null || size == 0) {
            throw new IllegalStateException("\u30d1\u30c3\u30b1\u30fc\u30b8\u30ea\u30b9\u30c8\u304c\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        if (this.classPath == null) {
            throw new IllegalStateException("\u30af\u30e9\u30b9\u30d1\u30b9\u304c\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        if (this.verbose) {
            this.tempOut.print(".");
        }
        this.resultManager.setChecks(new int[size]);
        this.resultManager.setErrors(new int[size]);
        this.resultManager.setInvalidWords(new TreeSet[size]);
        int i = 0;
        while (i < size) {
            this.resultManager.getInvalidWords()[i] = new TreeSet();
            ++i;
        }
        if (this.verbose) {
            this.tempOut.print(".");
        }
        this.searchPath(new File(this.classPath));
        if (this.verbose) {
            this.tempOut.println(".\u5b8c\u4e86");
        }
    }

    private void searchPath(File root) {
        block4: {
            block5: {
                if (!root.isDirectory()) break block5;
                String[] names = root.list();
                int i = 0;
                while (i < names.length) {
                    this.searchPath(new File(root, names[i]));
                    ++i;
                }
                break block4;
            }
            if (!root.getName().endsWith(".class")) break block4;
            this.resultManager.setNumberOfClasses(this.resultManager.getNumberOfClasses() + 1);
            String fqcn = this.getFQCN(root);
            if (this.isCheck(fqcn)) {
                int i = 0;
                while (i < this.packages.length) {
                    if (fqcn.startsWith(this.packages[i])) {
                        int[] nArray = this.resultManager.getChecks();
                        int n = i;
                        nArray[n] = nArray[n] + 1;
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    private void searchAndCheck(File root) {
        if (root.isDirectory()) {
            String[] names = root.list();
            int i = 0;
            while (i < names.length) {
                this.searchAndCheck(new File(root, names[i]));
                ++i;
            }
        } else if (root.getName().endsWith(".class")) {
            String fqcn = this.getFQCN(root);
            this.check(fqcn);
        }
    }

    public void execute() throws IllegalStateException {
        try {
            System.setOut(new EmptyPrintStream());
        }
        catch (RuntimeException e) {
            this.tempOut.println("\u203b \u5404\u30af\u30e9\u30b9\u3092\u30ed\u30fc\u30c9\u3059\u308b\u969b\u306b\u95a2\u4fc2\u306e\u7121\u3044\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u8868\u793a\u3055\u308c\u308b\u4e8b\u304c\u3042\u308a\u307e\u3059\u304c\u3001");
            this.tempOut.println("\u203b \u30a8\u30e9\u30fc\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        this.initialize();
        File root = new File(this.classPath);
        this.searchAndCheck(root);
        System.setOut(this.tempOut);
        System.out.println("\u30c1\u30a7\u30c3\u30af\u7d50\u679c\u3092\u51fa\u529b\u3057\u307e\u3059\u3002");
        this.resultManager.pack();
        HtmlResultWriter writer = new HtmlResultWriter(this.resultManager);
        try {
            ((AbstractResultWriter)writer).write();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("\u7528\u8a9e\u96c6\u30c1\u30a7\u30c3\u30af\u304c\u6b63\u5e38\u306b\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002");
        System.out.println("\u30c1\u30a7\u30c3\u30af\u7d50\u679c\u306b\u3064\u3044\u3066\u306f " + this.resultManager.getOutFileName() + " \u3092\u53c2\u7167\u3057\u3066\u4e0b\u3055\u3044\u3002");
    }

    private void check(String fqcn) {
        if (!this.isCheck(fqcn)) {
            return;
        }
        long l = System.currentTimeMillis();
        String checkPackage = null;
        int index = 0;
        while (index < this.packages.length) {
            if (fqcn.startsWith(this.packages[index])) {
                checkPackage = this.packages[index];
                if (!this.verbose || this.tempPackage.equals(checkPackage)) break;
                this.tempOut.println(checkPackage + " \u30d1\u30c3\u30b1\u30fc\u30b8\u306e\u30c1\u30a7\u30c3\u30af\u3092\u884c\u3044\u307e\u3059\u3002");
                this.tempPackage = checkPackage;
                break;
            }
            ++index;
        }
        Result result = new Result(fqcn);
        try {
            if (this.verbose) {
                this.tempOut.print(fqcn + " \u30af\u30e9\u30b9\u3092\u30c1\u30a7\u30c3\u30af.");
            }
            Class<?> c = Class.forName(fqcn);
            String className = null;
            ArrayList packs = new ArrayList();
            String pk = StringUtils.replace(fqcn, checkPackage, "", -1);
            StringTokenizer stk = new StringTokenizer(pk, ".");
            int max = stk.countTokens() - 1;
            int count = 0;
            while (stk.hasMoreTokens()) {
                if (count == max) {
                    className = stk.nextToken();
                    break;
                }
                String packageName = stk.nextToken();
                String[] packageWords = this.splitWords(packageName);
                if (this.isAssortmentError()) {
                    result.setPackageAssortErrorWords(this.getAssortErrorWords(packageWords));
                }
                result.setPackageInvalidWords(this.getUnmatchWords(packageWords));
                ++count;
            }
            String[] classWords = this.splitWords(className);
            if (this.isAssortmentError()) {
                result.setClassAssortErrorWords(this.getAssortErrorWords(classWords));
            }
            result.setClassInvalidWords(this.getUnmatchWords(classWords));
            if (this.verbose) {
                this.tempOut.print(".");
            }
            Field[] fields = c.getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                if (!fields[i].getName().startsWith("class$") && !fields[i].getName().startsWith("this$")) {
                    int modifier = fields[i].getModifiers();
                    if (!(this.fieldCheckLevel.equals("public") && !ModifierUtils.isPublic(modifier) || this.fieldCheckLevel.equals("protected") && !ModifierUtils.isProtected(modifier) || this.fieldCheckLevel.equals("package") && !ModifierUtils.isPackage(modifier) || this.fieldCheckLevel.equals("private") && !ModifierUtils.isPrivate(modifier))) {
                        String[] fieldWords = this.splitWords(fields[i].getName());
                        if (this.isAssortmentError()) {
                            result.setFieldAssortErrorWords(this.getAssortErrorWords(fieldWords));
                        }
                        result.setFieldInvalidWords(this.getUnmatchWords(fieldWords));
                    }
                }
                ++i;
            }
            if (this.verbose) {
                this.tempOut.print(".");
            }
            Method[] methods = c.getDeclaredMethods();
            int i2 = 0;
            while (i2 < methods.length) {
                int modifier = methods[i2].getModifiers();
                if (!(this.methodCheckLevel.equals("public") && !ModifierUtils.isPublic(modifier) || this.methodCheckLevel.equals("protected") && !ModifierUtils.isProtected(modifier) || this.methodCheckLevel.equals("package") && !ModifierUtils.isPackage(modifier) || this.methodCheckLevel.equals("private") && !ModifierUtils.isPrivate(modifier))) {
                    String[] methodWords = this.splitWords(methods[i2].getName());
                    if (this.isAssortmentError()) {
                        result.setMethodAssortErrorWords(this.getAssortErrorWords(methodWords));
                    }
                    result.setMethodInvalidWords(this.getUnmatchWords(methodWords));
                }
                ++i2;
            }
            if (result.hasErrors()) {
                int[] nArray = this.resultManager.getErrors();
                int n = index;
                nArray[n] = nArray[n] + 1;
                this.resultManager.addResult(result);
            }
            if (this.verbose) {
                this.tempOut.println(".\u5b8c\u4e86 [" + (System.currentTimeMillis() - l) + "\u30df\u30ea\u79d2]");
            }
        }
        catch (ClassNotFoundException e) {
            this.tempOut.println("\u30af\u30e9\u30b9\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002[" + fqcn + "]");
        }
    }

    private boolean isCheck(String fqcn) {
        boolean check = false;
        if (this.packages != null) {
            int i = 0;
            while (i < this.packages.length) {
                if (fqcn.startsWith(this.packages[i])) {
                    check = true;
                }
                ++i;
            }
        }
        return check;
    }

    private boolean isExistWord(String word) {
        boolean exist = false;
        int j = 0;
        while (j < this.terms.length) {
            if (word.toUpperCase().equals(this.terms[j])) {
                exist = true;
                break;
            }
            ++j;
        }
        return exist;
    }

    private String getFQCN(File classFile) {
        String fqcn = classFile.getAbsolutePath();
        fqcn = StringUtils.replace(fqcn, new File(this.classPath).getAbsolutePath() + File.separator, "", -1);
        fqcn = StringUtils.replace(fqcn, File.separator, ".", -1);
        fqcn = fqcn.substring(0, fqcn.length() - 6);
        return fqcn;
    }

    private String[] getAssortErrorWords(String[] words) {
        ArrayList<String> list = new ArrayList<String>();
        int i = words.length;
        while (i > 1) {
            int start = 0;
            while (start <= words.length - i) {
                StringBuffer buf = new StringBuffer();
                int j = start;
                while (j < i + start) {
                    buf.append(words[j]);
                    ++j;
                }
                if (this.isExistWord(buf.toString())) {
                    boolean allUpperCase = true;
                    char[] cs = buf.toString().toCharArray();
                    int j2 = 0;
                    while (j2 < cs.length) {
                        if (Character.isLowerCase(cs[j2])) {
                            allUpperCase = false;
                            break;
                        }
                        ++j2;
                    }
                    if (allUpperCase) {
                        buf = new StringBuffer();
                        int j3 = start;
                        while (j3 < i + start) {
                            buf.append(words[j3] + '_');
                            ++j3;
                        }
                        buf.deleteCharAt(buf.length() - 1);
                    }
                    list.add(buf.toString());
                }
                ++start;
            }
            --i;
        }
        String[] result = new String[list.size()];
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = (String)list.get(i2);
            ++i2;
        }
        return result;
    }

    private String[] getUnmatchWords(String[] words) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < words.length) {
            boolean skip = this.isExistWord(words[i]);
            if (!skip) {
                if (this.postfix.length > 0) {
                    int len = 0;
                    int j = 0;
                    while (j < this.postfix.length) {
                        if (words[i].toUpperCase().endsWith(this.postfix[j].toUpperCase())) {
                            len = this.postfix[j].length();
                            break;
                        }
                        ++j;
                    }
                    if (len > 0) {
                        words[i] = words[i].substring(0, words[i].length() - len);
                        skip = this.isExistWord(words[i]);
                    }
                }
                if (!skip) {
                    list.add(words[i]);
                }
            }
            ++i;
        }
        String[] result = new String[list.size()];
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = (String)list.get(i2);
            ++i2;
        }
        return result;
    }

    public void setAvailableLength(int availableLength) {
        this.availableLength = availableLength;
    }

    public void setAllowedPostfixes(String postfixes) {
        StringTokenizer stk = new StringTokenizer(postfixes, ", ");
        this.postfix = new String[stk.countTokens()];
        int i = 0;
        while (stk.hasMoreTokens()) {
            this.postfix[i] = stk.nextToken();
            ++i;
        }
    }

    public void setClassPath(String classPath) {
        this.classPath = StringUtils.replace(classPath, "/", File.separator, -1);
    }

    public void setPackages(String packages) {
        String packs = StringUtils.replace(packages, ".*", "", -1);
        StringTokenizer stk = new StringTokenizer(packs, ", \t\r\n");
        this.packages = new String[stk.countTokens()];
        int i = 0;
        while (stk.hasMoreTokens()) {
            this.packages[i] = stk.nextToken();
            ++i;
        }
        this.resultManager.setPackages(this.packages);
    }

    public void setGlossary(String glossaryFilePath) throws FileNotFoundException, IOException {
        File file = new File(StringUtils.replace(glossaryFilePath, "/", File.separator, -1));
        this.loadGlossary(file);
    }

    private void loadGlossary(File file) throws FileNotFoundException, IOException {
        ArrayList<String> list = new ArrayList<String>();
        FileReader reader = new FileReader(file);
        BufferedReader br = new BufferedReader(reader);
        String line = null;
        while ((line = br.readLine()) != null) {
            if (line.trim().length() < this.availableLength) continue;
            list.add(line.trim());
        }
        br.close();
        reader.close();
        int size = list.size();
        this.terms = new String[size];
        int i = 0;
        while (i < size) {
            this.terms[i] = ((String)list.get(i)).toUpperCase();
            ++i;
        }
        Arrays.sort(this.terms, new GlossaryComparator());
    }

    private String[] splitWords(String str) {
        return this.splitRulesManager.applyRule(this.splitRule, str);
    }

    public void setAssortmentError(boolean assortmentError) {
        this.assortmentError = assortmentError;
    }

    public boolean isAssortmentError() {
        return this.assortmentError;
    }

    public void setSplitRule(String ruleName) throws IllegalArgumentException {
        if (!(ruleName.equals("ignoreNumbers") || ruleName.equals("includeNumbers") || ruleName.equals("partOfWord"))) {
            throw new IllegalArgumentException("\u7121\u52b9\u306a\u5358\u8a9e\u5206\u5272\u898f\u5247\u540d\u3067\u3059\u3002[" + ruleName + "]");
        }
        this.splitRule = ruleName;
    }

    public void setOutFileName(String outFileName) {
        this.resultManager.setOutFileName(outFileName);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setFieldCheckLevel(String modifier) throws IllegalArgumentException {
        if (!(modifier.equals("public") || modifier.equals("protected") || modifier.equals("package") || modifier.equals("private"))) {
            throw new IllegalArgumentException("\"public\", \"protected\", \"package\", \"private\" \u4ee5\u5916\u306e\u5f15\u6570\u306f\u4f7f\u3048\u307e\u305b\u3093\u3002");
        }
        this.fieldCheckLevel = modifier;
    }

    public void setMethodCheckLevel(String modifier) throws IllegalArgumentException {
        if (!(modifier.equals("public") || modifier.equals("protected") || modifier.equals("package") || modifier.equals("private"))) {
            throw new IllegalArgumentException("\"public\", \"protected\", \"package\", \"private\" \u4ee5\u5916\u306e\u5f15\u6570\u306f\u4f7f\u3048\u307e\u305b\u3093\u3002");
        }
        this.methodCheckLevel = modifier;
    }

    public static void main(String[] args) throws Exception {
        JGlossary jg = new JGlossary();
        jg.setPackages("sample.packagea");
        jg.setClassPath("bin");
        jg.setGlossary("glossary.txt");
        jg.execute();
    }
}

