/*
 * Decompiled with CFR 0.152.
 */
package jp.javable.tool.jglossary.core;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jp.javable.tool.jglossary.core.Result;

public class ResultManager {
    private Map results = new TreeMap();
    private String[] packages;
    private int numberOfClasses = 0;
    private int[] checks;
    private int[] errors;
    private Set[] invalidWords;
    private String outFileName;

    public void addResult(Result result) {
        this.results.put(result.getFqcn(), result);
    }

    public Result getResult(String fqcn) {
        return (Result)this.results.get(fqcn);
    }

    public String[] getErrorClassNames() {
        Set set = this.results.keySet();
        int size = set.size();
        String[] fqcns = new String[size];
        return set.toArray(fqcns);
    }

    public void setOutFileName(String outFileName) {
        this.outFileName = outFileName;
    }

    public String getOutFileName() {
        if (this.outFileName == null) {
            return "jglossary.html";
        }
        return this.outFileName;
    }

    public void setPackages(String[] packages) {
        this.packages = packages;
    }

    public String[] getPackages() {
        return this.packages;
    }

    public void setNumberOfClasses(int numberOfClasses) {
        this.numberOfClasses = numberOfClasses;
    }

    public int getNumberOfClasses() {
        return this.numberOfClasses;
    }

    public void setChecks(int[] checks) {
        this.checks = checks;
    }

    public int[] getChecks() {
        return this.checks;
    }

    public void setErrors(int[] errors) {
        this.errors = errors;
    }

    public int[] getErrors() {
        return this.errors;
    }

    public void setInvalidWords(Set[] invalidWords) {
        this.invalidWords = invalidWords;
    }

    public Set[] getInvalidWords() {
        return this.invalidWords;
    }

    public void pack() {
        String[] classes = this.getErrorClassNames();
        int i = 0;
        while (i < classes.length) {
            int j = 0;
            while (j < this.packages.length) {
                if (classes[i].startsWith(this.packages[j])) {
                    Set set = this.invalidWords[j];
                    Result result = this.getResult(classes[i]);
                    set.addAll(Arrays.asList(result.getPackageInvalidWords()));
                    set.addAll(Arrays.asList(result.getClassInvalidWords()));
                    set.addAll(Arrays.asList(result.getFieldInvalidWords()));
                    set.addAll(Arrays.asList(result.getMethodInvalidWords()));
                }
                ++j;
            }
            ++i;
        }
    }
}

